<?php

class Rooms extends Eloquent {

	protected $table = 'rooms';
	public $timestamps = true;
	protected $fillable = array('title', 'no_of_person', 'category_id', 'description', 'open_at', 'Status', 'branch_id', 'policy', 'tags', 'active');

	public function Categories()
	{
		return $this->belongsToMany('Category', 'category_id');
	}

	public function images()
	{
		return $this->hasMany('Gallary', 'product_id');
	}

	public function Features()
	{
		return $this->belongsToMany('RoomsFeature', 'feature_id');
	}

	public function Branches()
	{
		return $this->belongsTo('Branch');
	}

}