<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('user', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('role')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('authorization', function(Blueprint $table) {
			$table->foreign('authorization_set_id')->references('id')->on('authorization_set')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('authorization', function(Blueprint $table) {
			$table->foreign('resource_id')->references('id')->on('resource')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_authorization_set', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('role')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_authorization_set', function(Blueprint $table) {
			$table->foreign('authorization_set_id')->references('id')->on('authorization_set')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('user', function(Blueprint $table) {
			$table->dropForeign('user_role_id_foreign');
		});
		Schema::table('authorization', function(Blueprint $table) {
			$table->dropForeign('authorization_authorization_set_id_foreign');
		});
		Schema::table('authorization', function(Blueprint $table) {
			$table->dropForeign('authorization_resource_id_foreign');
		});
		Schema::table('role_authorization_set', function(Blueprint $table) {
			$table->dropForeign('role_authorization_set_role_id_foreign');
		});
		Schema::table('role_authorization_set', function(Blueprint $table) {
			$table->dropForeign('role_authorization_set_authorization_set_id_foreign');
		});
	}
}