<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('profiles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('profiles', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('profiles', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->foreign('company_division_id')->references('id')->on('company_divisions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('teams', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('teams', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tasks', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('company_divisions', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('applicants', function(Blueprint $table) {
			$table->foreign('job_id')->references('id')->on('jobs')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('applicant_ratings', function(Blueprint $table) {
			$table->foreign('applicant_id')->references('id')->on('applicants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('quiz_per_project', function(Blueprint $table) {
			$table->foreign('job_id')->references('id')->on('jobs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('quiz_per_project', function(Blueprint $table) {
			$table->foreign('quiz_id')->references('id')->on('quizzes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('quiz_per_applicant', function(Blueprint $table) {
			$table->foreign('quiz_id')->references('id')->on('quizzes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('quiz_per_applicant', function(Blueprint $table) {
			$table->foreign('applicant_id')->references('id')->on('applicants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('profiles', function(Blueprint $table) {
			$table->dropForeign('profiles_user_id_foreign');
		});
		Schema::table('profiles', function(Blueprint $table) {
			$table->dropForeign('profiles_company_id_foreign');
		});
		Schema::table('profiles', function(Blueprint $table) {
			$table->dropForeign('profiles_role_id_foreign');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->dropForeign('roles_company_id_foreign');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->dropForeign('roles_company_division_id_foreign');
		});
		Schema::table('teams', function(Blueprint $table) {
			$table->dropForeign('teams_user_id_foreign');
		});
		Schema::table('teams', function(Blueprint $table) {
			$table->dropForeign('teams_project_id_foreign');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_team_id_foreign');
		});
		Schema::table('tasks', function(Blueprint $table) {
			$table->dropForeign('tasks_project_id_foreign');
		});
		Schema::table('company_divisions', function(Blueprint $table) {
			$table->dropForeign('company_divisions_company_id_foreign');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->dropForeign('jobs_company_id_foreign');
		});
		Schema::table('applicants', function(Blueprint $table) {
			$table->dropForeign('applicants_job_id_foreign');
		});
		Schema::table('applicant_ratings', function(Blueprint $table) {
			$table->dropForeign('applicant_ratings_applicant_id_foreign');
		});
		Schema::table('quiz_per_project', function(Blueprint $table) {
			$table->dropForeign('quiz_per_project_job_id_foreign');
		});
		Schema::table('quiz_per_project', function(Blueprint $table) {
			$table->dropForeign('quiz_per_project_quiz_id_foreign');
		});
		Schema::table('quiz_per_applicant', function(Blueprint $table) {
			$table->dropForeign('quiz_per_applicant_quiz_id_foreign');
		});
		Schema::table('quiz_per_applicant', function(Blueprint $table) {
			$table->dropForeign('quiz_per_applicant_applicant_id_foreign');
		});
	}
}