<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectTable extends Migration {

	public function up()
	{
		Schema::create('project', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title');
			$table->string('cost');
			$table->string('estmated_time');
			$table->string('estimated_budget');
			$table->text('description');
			$table->text('notes');
			$table->string('start_time');
			$table->date('end_time');
			$table->boolean('assets')->default(0);
			$table->boolean('online');
			$table->boolean('lobby_chat');
			$table->boolean('chat');
			$table->boolean('voice');
			$table->boolean('unity_logo');
			$table->boolean('rooms');
			$table->boolean('matchmaking');
			$table->enum('platform', array('aracde', 'pc', 'web', 'mobile'));
			$table->enum('status', array('1', '2', '3', '4'));
			$table->boolean('type');
		});
	}

	public function down()
	{
		Schema::drop('project');
	}
}