<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CartItem extends Eloquent {

	protected $table = 'cart_items';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('cart_id', 'model_type', 'model_id', 'model_price_key', 'currency_id', 'quantity', 'unit_price', 'unit_tax', 'sub_total', 'tax', 'tax_rate', 'total', 'discount', 'grand_total', 'c_var', 'c_int', 'c_txt');
	protected $visible = array('cart_id', 'model_type', 'model_id', 'model_price_key', 'currency_id', 'quantity', 'unit_price', 'unit_tax', 'sub_total', 'tax', 'tax_rate', 'total', 'discount', 'grand_total', 'c_var', 'c_int', 'c_txt');

	public function cart()
	{
		return $this->belongsTo('Cart');
	}

	public function currency()
	{
		return $this->belongsTo('Currency');
	}

}