<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class SupplyInvoice extends Eloquent {

	protected $table = 'supply_invoice';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'country_id', 'supply_id', 'quantity', 'price', 'total', 'description_en', 'description_ar', 'bill_no');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

	public function supply()
	{
		return $this->belongsTo('Supply', 'supply_id');
	}

}