<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Warehouse extends Eloquent {

	protected $table = 'warehouse';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('country_id', 'supply_id', 'total_quantity', 'out_quantity', 'damaged_quantity');

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

	public function supply()
	{
		return $this->belongsTo('Supply', 'supply_id');
	}

}