<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class GroupPlanObject extends Model 
{

    protected $table = 'group_plan_objects';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function group_plan()
    {
        return $this->belongsTo('GroupPlan');
    }

    public function peg_object()
    {
        return $this->belongsTo('PegObject');
    }

    public function group_plan_object_items()
    {
        return $this->hasMany('GroupPlanObjectItem');
    }

}