<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserSection extends Model 
{

    protected $table = 'user_sections';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function users()
    {
        return $this->morphMany('User', 'usable');
    }

    public function groups()
    {
        return $this->hasMany('UserGroup');
    }

}