<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePegObjectsTable extends Migration {

	public function up()
	{
		Schema::create('peg_objects', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('pack_type_id');
			$table->integer('number');
			$table->text('body');
			$table->enum('type', array(''path'', ''pfs''));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('peg_objects');
	}
}