<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class GroupPlanObject extends Eloquent {

	protected $table = 'group_plan_objects';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function group_plan()
	{
		return $this->belongsTo('GroupPlan');
	}

	public function peg_object()
	{
		return $this->belongsTo('PegObject');
	}

	public function group_plan_object_items()
	{
		return $this->hasMany('GroupPlanObjectItem');
	}

}