<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class UserPack extends Eloquent {

	protected $table = 'user_packs';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user_group()
	{
		return $this->belongsTo('UserGroup');
	}

	public function users()
	{
		return $this->morphMany('User', 'usable');
	}

	public function pack_type()
	{
		return $this->belongsTo('PackType');
	}

}