<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressesTable extends Migration {

	public function up()
	{
		Schema::create('addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('addressable_id');
			$table->string('addressable_type');
			$table->text('address');
			$table->string('city');
			$table->string('state');
			$table->string('country');
			$table->decimal('latitude', 10,8);
			$table->decimal('longitude', 11,8);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('addresses');
	}
}