<?php

namespace App\Models;

class Notification extends Eloquent {

	protected $table = 'notifications';
	public $timestamps = true;

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function admin()
	{
		return $this->belongsTo('Employee', 'admin_id');
	}

	public function booking()
	{
		return $this->hasOne('Booking', 'booking_id');
	}

	public function subscription()
	{
		return $this->belongsTo('Subscription', 'subscription_id');
	}

}