<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServicesTable extends Migration {

	public function up()
	{
		Schema::create('services', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 250);
			$table->text('description');
			$table->date('start_date');
			$table->date('end_date');
			$table->enum('status', array('active', 'inActive'));
			$table->integer('branch_id');
			$table->boolean('display_in_app');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('services');
	}
}