<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Address extends Model 
{

    protected $table = 'address';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('adress', 'latitude', 'longitude', 'client_id');

    public function client()
    {
        return $this->belongsTo('Client', 'client_id');
    }

}