<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrderCancel extends Model 
{

    protected $table = 'order_cancel';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('reason_id', 'order_id', 'review');

    public function reason()
    {
        return $this->belongsTo('CancelReason', 'reason_id');
    }

    public function order()
    {
        return $this->belongsTo('Order', 'order_id');
    }

}