<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TakeFrom extends Model 
{

    protected $table = 'take_from';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('driver_id', 'city_id');

    public function driver()
    {
        return $this->belongsTo('Driver', 'driver_id');
    }

    public function city()
    {
        return $this->belongsTo('City', 'city_id');
    }

}