<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderTable extends Migration {

	public function up()
	{
		Schema::create('order', function(Blueprint $table) {
			$table->timestamps();
			$table->softDeletes();
			$table->increments('id');
			$table->datetime('delivery_date')->nullable();
			$table->integer('user_id')->nullable();
			$table->integer('client_id')->nullable();
			$table->integer('address_id')->nullable();
			$table->integer('driver_id')->nullable();
			$table->integer('store_id')->nullable();
			$table->integer('payment_id')->nullable();
			$table->string('status')->nullable();
			$table->double('sub_total')->nullable();
			$table->double('delivery_fees')->nullable();
			$table->double('total')->nullable();
			$table->integer('discount_id')->nullable();
			$table->string('from')->nullable();
			$table->string('to')->nullable();
			$table->text('note')->nullable();
			$table->integer('client_rate')->nullable();
			$table->integer('store_rate')->nullable();
			$table->integer('driver_rate')->nullable();
			$table->text('review')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('order');
	}
}