<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDeliveryScheduleTable extends Migration {

	public function up()
	{
		Schema::create('delivery_schedule', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('from_hour')->nullable();
			$table->string('to_hour')->nullable();
			$table->enum('day_off', array('1', '2', '3', '4', '5', '6', '7'))->nullable();
			$table->integer('store_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('delivery_schedule');
	}
}