<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Client extends Eloquent {

	protected $table = 'client';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'phone', 'email', 'city_id', 'point', 'rate', 'user_id');

	public function city()
	{
		return $this->belongsTo('City', 'city_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function addresses()
	{
		return $this->hasMany('Address', 'client_id');
	}

}