<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class DeliveryExternal extends Eloquent {

	protected $table = 'delivery_external';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('level_id', 'price');

	public function level()
	{
		return $this->belongsTo('DeliveryLevel', 'level_id');
	}

}