<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class DeliveryInternal extends Eloquent {

	protected $table = 'delivery_internal';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('store_id', 'level_id', 'price');

	public function store()
	{
		return $this->belongsTo('Store', 'store_id');
	}

	public function level()
	{
		return $this->belongsTo('DeliveryLevel', 'level_id');
	}

}