<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ProductOption extends Eloquent {

	protected $table = 'product_option';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('product_id', 'option_category_id', 'option_id', 'price');

	public function product()
	{
		return $this->belongsTo('Product', 'product_id');
	}

	public function option_category()
	{
		return $this->belongsTo('OptionCategory', 'option_category_id');
	}

	public function option()
	{
		return $this->belongsTo('Option', 'option_id');
	}

}