<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Store extends Eloquent {

	protected $table = 'store';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('available', 'parent_id', 'country_id', 'password', 'name_en', 'name_ar', 'phone', 'email', 'store_category_id', 'min_charge', 'status', 'rate', 'latitude', 'longitude', 'city_id', 'address_en', 'address_ar', 'delivery_type', 'min_delivery', 'duration', 'from', 'to', 'description_en', 'description_ar', 'com_email', 'com_phone', 'package_id', 'user_id');

	public function parent()
	{
		return $this->belongsTo('Store', 'parent_id');
	}

	public function branches()
	{
		return $this->hasMany('Store', 'parent_id');
	}

	public function store_category()
	{
		return $this->belongsTo('StoreCategory', 'store_category_id');
	}

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

	public function city()
	{
		return $this->belongsTo('City', 'city_id');
	}

	public function cities()
	{
		return $this->belongsToMany('City', 'store_city', 'store_id', 'city_id');
	}

	public function package()
	{
		return $this->belongsTo('Package', 'package_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function categories()
	{
		return $this->hasMany('Category', 'store_id');
	}

	public function offers()
	{
		return $this->hasMany('Offer', 'store_id');
	}

	public function promotions()
	{
		return $this->hasMany('Promotion', 'store_id');
	}

	public function payments()
	{
		return $this->hasMany('StorePayment', 'store_id');
	}

	public function products()
	{
		return $this->hasMany('Product', 'store_id');
	}

}