<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class StoreCity extends Eloquent {

	protected $table = 'store_city';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('city_id', 'store_id');

	public function store()
	{
		return $this->belongsTo('Store', 'store_id');
	}

	public function city()
	{
		return $this->belongsTo('City', 'city_id');
	}

}