<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class StorePayment extends Eloquent {

	protected $table = 'store_payment';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('payment_id', 'store_id');

	public function payment()
	{
		return $this->belongsTo('PaymentMethod', 'payment_id');
	}

	public function store()
	{
		return $this->belongsTo('Store', 'store_id');
	}

}