<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TakeFrom extends Eloquent {

	protected $table = 'take_from';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('driver_id', 'city_id');

	public function driver()
	{
		return $this->belongsTo('Driver', 'driver_id');
	}

	public function city()
	{
		return $this->belongsTo('City', 'city_id');
	}

}