<?php

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = false;

	public function blood_type()
	{
		return $this->belongsToMany('BloodType');
	}

	public function city()
	{
		return $this->belongsTo('City');
	}

	public function messages()
	{
		return $this->hasMany('Messages');
	}

	public function notifications()
	{
		return $this->belongsToMany('Notification');
	}

	public function favorite_articles()
	{
		return $this->hasMany('Article');
	}

	public function donationRequests()
	{
		return $this->hasMany('DonationRequest');
	}

	public function governments()
	{
		return $this->belongsToMany('Government');
	}

}