<?php

namespace Category;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Category extends Eloquent {

	protected $table = 'categories';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'description');

	public function class()
	{
		return $this->belongsTo('Class\Class', 'class_id');
	}

	public function products()
	{
		return $this->hasMany('Product\Product');
	}

}