<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('brand_id')->unsigned();
			$table->string('name', 50);
			$table->text('description')->nullable();
			$table->integer('category_id')->unsigned()->nullable();
			$table->string('barcode_template', 5);
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}