<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class QuestionUserAnswer extends Model 
{

    protected $table = 'question_user_answers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function answer()
    {
        return $this->belongsTo('QuestionAnswer');
    }

    public function question()
    {
        return $this->belongsTo('Question');
    }

    public function questionBelonging()
    {
        return $this->belongsTo('Questionable');
    }

}