<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class QuestionUserAnswer extends Eloquent {

	protected $table = 'question_user_answers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function answer()
	{
		return $this->belongsTo('QuestionAnswer');
	}

	public function question()
	{
		return $this->belongsTo('Question');
	}

	public function questionBelonging()
	{
		return $this->belongsTo('Questionable');
	}

}