<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingTable extends Migration {

	public function up()
	{
		Schema::create('booking', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('location')->nullable();
			$table->integer('service_id')->nullable();
			$table->datetime('booking_time')->nullable();
			$table->integer('agency_id')->nullable();
			$table->integer('user_id')->nullable();
			$table->integer('escort_id')->nullable();
			$table->integer('status')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('booking');
	}
}