<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Booking extends Eloquent {

	protected $table = 'booking';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function model()
	{
		return $this->hasOne('App\Models\Escort', 'escort_id');
	}

	public function service()
	{
		return $this->hasOne('App\Models\Service', 'service_id');
	}

}