<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateS3FilesStorageTable extends Migration {

	public function up()
	{
		Schema::create('S3_files_storage', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('storable_id')->unsigned();
			$table->string('storable_type', 255);
			$table->string('file_name');
			$table->string('file_hash');
			$table->string('media_type');
			$table->integer('tenant_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('S3_files_storage');
	}
}