<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->string('body');
			$table->timestamp('start_time');
			$table->timestamp('end_time');
			$table->string('excerpt');
			$table->timestamp('publish_date');
			$table->integer('user_id')->unsigned();
			$table->integer('tenant_id');
			$table->boolean('is_approved');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}