<?php

namespace App\Models\Tenant\tenants;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Tenant extends Eloquent {

	protected $table = 'tenants';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function posts()
	{
		return $this->hasMany('App\Models\Post\Post');
	}

	public function S3Files()
	{
		return $this->morphMany('S3FilesStorage');
	}

	public function meta()
	{
		return $this->morphMany('TenantMeta');
	}

	public function knowledge_base()
	{
		return $this->hasOne('KnowledgeBase');
	}

	public function users()
	{
		return $this->belongsToMany('User');
	}

}