<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostsTable extends Migration {

	public function up()
	{
		Schema::create('posts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 255);
			$table->text('body');
			$table->string('slug', 255);
			$table->integer('user_id');
			$table->integer('type_id');
			$table->enum('status', array('active', 'inactive', 'suspended', 'expired', 'duplicated'));
			$table->datetime('expiry_date');
			$table->string('url', 512);
			$table->integer('category_id');
			$table->text('meta');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('posts');
	}
}