<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDiscountsTable extends Migration {

	public function up()
	{
		Schema::create('Discounts', function(Blueprint $table) {
			$table->increments('Id', true);
			$table->string('Code', 64);
			$table->smallInteger('Value');
			$table->boolean('Valid')->default(True);
			$table->boolean('HasFilter')->default(False);
			$table->string('Start_Date', 10)->nullable();
			$table->string('End_Date', 10)->nullable();
			$table->timestamps();
			$table->timestamp('updated_at')->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('Discounts');
	}
}