<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSessionsTable extends Migration {

	public function up()
	{
		Schema::create('Sessions', function(Blueprint $table) {
			$table->increments('Id', true)->primary();
			$table->string('Title', 128);
			$table->string('Description')->nullable();
			$table->string('DownloadUrl', 512);
			$table->integer('EpisodeId')->unsigned();
			$table->timestamps();
			$table->timestamp('updated_at')->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('Sessions');
	}
}