<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('Users', function(Blueprint $table) {
			$table->increments('Id', true);
			$table->string('Full_name', 128);
			$table->string('Native_ID', 10)->nullable();
			$table->string('Email');
			$table->string('Mobile', 11);
			$table->string('Profile')->nullable();
			$table->string('Story', 4000)->nullable();
			$table->string('IP');
			$table->timestamps();
			$table->timestamp('updated_at')->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('Users');
	}
}