<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEpisodesTable extends Migration {

	public function up()
	{
		Schema::create('Episodes', function(Blueprint $table) {
			$table->increments('Id', true)->primary();
			$table->string('Title');
			$table->string('Description')->nullable();
			$table->string('Price');
			$table->string('Duration');
			$table->string('Cover');
			$table->integer('CategoryId')->unsigned();
			$table->integer('ParentId')->unsigned();
			$table->timestamps();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('Episodes');
	}
}