<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePublishersTable extends Migration {

	public function up()
	{
		Schema::create('Publishers', function(Blueprint $table) {
			$table->increments('Id', true);
			$table->string('Full_name', 64);
			$table->string('Email');
			$table->string('Mobile', 11);
			$table->string('Native_ID', 10);
			$table->string('Profile')->nullable();
			$table->string('Story', 4000);
			$table->string('IP');
			$table->timestamp('created_at');
			$table->timestamp('updated_at')->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('Publishers');
	}
}