<?php

namespace shop.Category;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Category extends Eloquent {

	protected $table = 'Category';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('Id', 'Title', 'created_at');

	public function episodes()
	{
		return $this->belongsTo('Episodes', 'CategoryId');
	}

}