<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('first_name', 'last_name', 'gender', 'email', 'email_status', 'phone', 'phone_status', 'address', 'level', 'type', 'identity', 'nationality');

	public function arbitrator()
	{
		return $this->hasOne('App/Models\Arbitrator', 'user_id');
	}

	public function country()
	{
		return $this->hasOne('App/Models\Country', 'country_id');
	}

}