<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJobAdvertTable extends Migration {

	public function up()
	{
		Schema::create('job_advert', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('job_id')->unsigned();
			$table->integer('nb_of_candidates')->unsigned();
			$table->boolean('trainee_accepted');
			$table->integer('language_id')->unsigned();
			$table->integer('driving_licence_id')->unsigned();
			$table->integer('hospitality_id')->unsigned();
			$table->integer('department_id')->unsigned();
			$table->integer('speciality_id')->unsigned();
			$table->integer('public_id')->unsigned();
			$table->date('start_date');
			$table->date('end_date');
			$table->integer('contract_type_id')->unsigned();
			$table->float('wage');
			$table->integer('wage_type_id')->unsigned();
			$table->string('title');
			$table->string('description');
			$table->binary('file');
			$table->string('contact');
			$table->string('email');
			$table->string('url');
			$table->string('slug');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('job_advert');
	}
}