<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class JobAdvert extends Eloquent {

	protected $table = 'job_advert';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('nb_of_candidates', 'trainee_accepted', 'start_date', 'end_date', 'wage', 'title', 'description', 'file', 'url', 'slug');

	public function user()
	{
		return $this->belongsTo('\User');
	}

	public function certificatesGraduations()
	{
		return $this->belongsToMany('\Graduation');
	}

}