<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Post extends Model 
{

    protected $table = 'post';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title', 'content', 'slug');

    public function category()
    {
        return $this->belongsTo('\Category', 'category_id');
    }

    public function tags()
    {
        return $this->belongsToMany('\Tag');
    }

    public function notations()
    {
        return $this->hasMany('\Notation');
    }

}