<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDomainsTable extends Migration {

	public function up()
	{
		Schema::create('domains', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('uuid');
			$table->string('domain');
			$table->boolean('status');
			$table->bigInteger('page_id')->unsigned();
			$table->bigInteger('customer_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('domains');
	}
}